/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.treeparser;

import com.joanju.DataXferStream;
import com.joanju.Xferable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.prorefactor.core.schema.Schema;
import org.prorefactor.core.schema.Table;
import org.prorefactor.treeparser.Block;
import org.prorefactor.treeparser.Call;
import org.prorefactor.treeparser.Dataset;
import org.prorefactor.treeparser.Datasource;
import org.prorefactor.treeparser.Query;
import org.prorefactor.treeparser.Routine;
import org.prorefactor.treeparser.Stream;
import org.prorefactor.treeparser.Symbol;
import org.prorefactor.treeparser.SymbolScopeRoot;
import org.prorefactor.treeparser.TableBuffer;
import org.prorefactor.treeparser.Variable;
import org.prorefactor.treeparser.Widget;
import org.prorefactor.widgettypes.FieldLevelWidgetI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymbolScope
implements Xferable {
    private static Schema schema = Schema.getInstance();
    protected ArrayList<Symbol> allSymbols = new ArrayList();
    protected ArrayList<Call> callList = new ArrayList();
    protected ArrayList<SymbolScope> childScopes = new ArrayList();
    protected Block rootBlock;
    protected Map<String, TableBuffer> bufferMap = new HashMap<String, TableBuffer>();
    protected Map<String, FieldLevelWidgetI> fieldLevelWidgetMap = new HashMap<String, FieldLevelWidgetI>();
    protected Map<String, Routine> routineMap = new HashMap<String, Routine>();
    protected Map<Table, TableBuffer> unnamedBuffers = new HashMap<Table, TableBuffer>();
    protected Map<Integer, Map> typeMap = new HashMap<Integer, Map>();
    protected Map<String, Variable> variableMap = new HashMap<String, Variable>();
    protected SymbolScope parentScope;
    protected SymbolScopeRoot rootScope;
    private static final Integer DATASET = new Integer(1014);
    private static final Integer DATASOURCE = new Integer(1013);
    private static final Integer QUERY = new Integer(623);
    private static final Integer STREAM = new Integer(753);

    public SymbolScope() {
        this.typeMap.put(new Integer(841), this.variableMap);
    }

    protected SymbolScope(SymbolScope parentScope) {
        this.typeMap.put(new Integer(841), this.variableMap);
        this.parentScope = parentScope;
        if (parentScope != null) {
            this.rootScope = parentScope.rootScope;
        }
    }

    public void add(FieldLevelWidgetI widget) {
        this.fieldLevelWidgetMap.put(widget.getName().toLowerCase(), widget);
    }

    public void add(Routine routine) {
        this.routineMap.put(routine.getName().toLowerCase(), routine);
    }

    public void add(TableBuffer tableBuffer) {
        Table table = tableBuffer.getTable();
        this.addTableBuffer(tableBuffer.getName(), table, tableBuffer);
        this.rootScope.addTableDefinitionIfNew(table);
    }

    public void add(Variable var) {
        this.variableMap.put(var.getName().toLowerCase(), var);
    }

    public void add(Symbol symbol) {
        if (symbol instanceof FieldLevelWidgetI) {
            this.add((FieldLevelWidgetI)((Object)symbol));
        } else if (symbol instanceof Variable) {
            this.add((Variable)symbol);
        } else if (symbol instanceof Routine) {
            this.add((Routine)symbol);
        } else if (symbol instanceof TableBuffer) {
            this.add((TableBuffer)symbol);
        } else {
            Integer type = new Integer(symbol.getProgressType());
            HashMap<String, Symbol> map = this.typeMap.get(type);
            if (map == null) {
                map = new HashMap<String, Symbol>();
                this.typeMap.put(type, map);
            }
            map.put(symbol.getName().toLowerCase(), symbol);
        }
    }

    public SymbolScope addScope() {
        SymbolScope newScope = new SymbolScope(this);
        this.childScopes.add(newScope);
        return newScope;
    }

    void addSymbol(Symbol symbol) {
        this.allSymbols.add(symbol);
    }

    private void addTableBuffer(String name, Table table, TableBuffer buffer) {
        if (name.length() == 0) {
            if (table.getStoretype() == 1102) {
                this.unnamedBuffers.put(table, buffer);
            } else {
                this.bufferMap.put(table.getName().toLowerCase(), buffer);
            }
        } else {
            this.bufferMap.put(name.toLowerCase(), buffer);
        }
    }

    public TableBuffer defineBuffer(String name, Table table) {
        TableBuffer buffer = new TableBuffer(name, this, table);
        this.addTableBuffer(name, table, buffer);
        return buffer;
    }

    public int depth() {
        int depth = 0;
        SymbolScope scope = this;
        while ((scope = scope.getParentScope()) != null) {
            ++depth;
        }
        return depth;
    }

    public ArrayList<Symbol> getAllSymbols() {
        return new ArrayList<Symbol>(this.allSymbols);
    }

    public <T extends Symbol> ArrayList<T> getAllSymbols(Class<T> klass) {
        ArrayList<Symbol> ret = new ArrayList<Symbol>();
        for (Symbol s : this.allSymbols) {
            if (!klass.isInstance(s)) continue;
            ret.add(s);
        }
        return ret;
    }

    public ArrayList<Symbol> getAllSymbolsDeep() {
        ArrayList<Symbol> ret = new ArrayList<Symbol>(this.allSymbols);
        for (SymbolScope child : this.childScopes) {
            ret.addAll(child.getAllSymbolsDeep());
        }
        return ret;
    }

    public <T extends Symbol> ArrayList<T> getAllSymbolsDeep(Class<T> klass) {
        ArrayList<T> ret = this.getAllSymbols(klass);
        for (SymbolScope child : this.childScopes) {
            ret.addAll(child.getAllSymbols(klass));
        }
        return ret;
    }

    public Set getBufferSet() {
        return this.bufferMap.entrySet();
    }

    public TableBuffer getBufferSymbol(String inName) {
        TableBuffer symbol = this.lookupBuffer(inName);
        if (symbol != null) {
            return symbol;
        }
        Table table = schema.lookupTable(inName);
        if (table == null) {
            return null;
        }
        return this.getUnnamedBuffer(table);
    }

    public ArrayList<Call> getCallList() {
        return this.callList;
    }

    public ArrayList<SymbolScope> getChildScopes() {
        return new ArrayList<SymbolScope>(this.childScopes);
    }

    public ArrayList<SymbolScope> getChildScopesDeep() {
        ArrayList<SymbolScope> ret = new ArrayList<SymbolScope>();
        for (SymbolScope child : this.childScopes) {
            ret.add(child);
            ret.addAll(child.getChildScopesDeep());
        }
        return ret;
    }

    public SymbolScope getParentScope() {
        return this.parentScope;
    }

    public Block getRootBlock() {
        return this.rootBlock;
    }

    public SymbolScopeRoot getRootScope() {
        return this.rootScope;
    }

    public TableBuffer getUnnamedBuffer(Table table) {
        assert (table.getStoretype() == 1102);
        SymbolScope nextScope = this;
        while (nextScope != null) {
            TableBuffer buffer = nextScope.unnamedBuffers.get(table);
            if (buffer != null) {
                return buffer;
            }
            nextScope = nextScope.parentScope;
        }
        return this.rootScope.defineBuffer("", table);
    }

    public Collection<Variable> getVariables() {
        return this.variableMap.values();
    }

    public boolean hasRoutine(String name) {
        if (name == null) {
            return false;
        }
        return this.routineMap.containsKey(name.toLowerCase());
    }

    public boolean isActiveIn(SymbolScope theScope) {
        while (theScope != null) {
            if (this == theScope) {
                return true;
            }
            theScope = theScope.parentScope;
        }
        return false;
    }

    public TableBuffer lookupBuffer(String inName) {
        String bufferPart;
        String[] parts = inName.split("\\.");
        String dbPart = "";
        if (parts.length == 1) {
            bufferPart = inName;
        } else {
            dbPart = parts[0];
            bufferPart = parts[1];
        }
        TableBuffer symbol = this.bufferMap.get(bufferPart.toLowerCase());
        if (symbol == null || dbPart.length() != 0 && !dbPart.equalsIgnoreCase(symbol.getTable().getDatabase().getName())) {
            if (this.parentScope == null) {
                return null;
            }
            return this.parentScope.lookupBuffer(inName);
        }
        return symbol;
    }

    public Dataset lookupDataset(String name) {
        return (Dataset)this.lookupSymbolLocally(DATASET, name);
    }

    public Datasource lookupDatasource(String name) {
        return (Datasource)this.lookupSymbolLocally(DATASOURCE, name);
    }

    public FieldLevelWidgetI lookupFieldLevelWidget(String inName) {
        FieldLevelWidgetI wid = this.fieldLevelWidgetMap.get(inName.toLowerCase());
        if (wid == null && this.parentScope != null) {
            return this.parentScope.lookupFieldLevelWidget(inName);
        }
        return wid;
    }

    public Query lookupQuery(String name) {
        return (Query)this.lookupSymbolLocally(QUERY, name);
    }

    public Routine lookupRoutine(String name) {
        Routine routine = this.routineMap.get(name.toLowerCase());
        return routine;
    }

    public Stream lookupStream(String name) {
        return (Stream)this.lookupSymbolLocally(STREAM, name);
    }

    public Symbol lookupSymbol(Integer symbolType, String name) {
        Symbol symbol = this.lookupSymbolLocally(symbolType, name);
        if (symbol != null) {
            return symbol;
        }
        if (this.parentScope != null) {
            return this.parentScope.lookupSymbol(symbolType, name);
        }
        return null;
    }

    public Symbol lookupSymbolLocally(Integer symbolType, String name) {
        Map map = this.typeMap.get(symbolType);
        if (map == null) {
            return null;
        }
        return (Symbol)map.get(name.toLowerCase());
    }

    public TableBuffer lookupTableOrBufferSymbol(String inName) {
        Table table = schema.lookupTable(inName);
        if (table != null && table.getName().length() == inName.length()) {
            return this.getUnnamedBuffer(table);
        }
        TableBuffer ret2 = this.lookupBuffer(inName);
        if (ret2 != null) {
            return ret2;
        }
        if (table != null) {
            return this.getUnnamedBuffer(table);
        }
        if (this.parentScope == null) {
            return null;
        }
        return this.parentScope.lookupTableOrBufferSymbol(inName);
    }

    public TableBuffer lookupTempTable(String name) {
        TableBuffer buff = this.bufferMap.get(name.toLowerCase());
        if (buff != null) {
            return buff;
        }
        if (this.parentScope == null) {
            return null;
        }
        return this.parentScope.lookupTempTable(name);
    }

    public Variable lookupVariable(String inName) {
        Variable var = this.variableMap.get(inName.toLowerCase());
        if (var == null && this.parentScope != null) {
            return this.parentScope.lookupVariable(inName);
        }
        return var;
    }

    public Widget lookupWidget(int widgetType, String name) {
        Widget ret = (Widget)this.lookupSymbolLocally(new Integer(widgetType), name);
        if (ret == null && this.parentScope != null) {
            return this.parentScope.lookupWidget(widgetType, name);
        }
        return ret;
    }

    public void registerCall(Call call) {
        this.callList.add(call);
    }

    public void setRootBlock(Block block) {
        this.rootBlock = block;
    }

    @Override
    public void writeXferBytes(DataXferStream out) throws IOException {
        out.writeRef(this.allSymbols);
        out.writeRef(this.callList);
        out.writeRef(this.childScopes);
        out.writeRef(this.rootBlock);
        out.writeRef(this.bufferMap);
        out.writeRef(this.fieldLevelWidgetMap);
        out.writeRef(this.routineMap);
        out.writeRef(this.unnamedBuffers);
        out.writeRef(this.typeMap);
        out.writeRef(this.variableMap);
        out.writeRef(this.parentScope);
        out.writeRef(this.rootScope);
    }

    @Override
    public void writeXferSchema(DataXferStream out) throws IOException {
        out.schemaRef("allSymbols");
        out.schemaRef("callList");
        out.schemaRef("childScopes");
        out.schemaRef("rootBlock");
        out.schemaRef("bufferMap");
        out.schemaRef("fieldLevelWidgetMap");
        out.schemaRef("routineMap");
        out.schemaRef("unnamedBuffers");
        out.schemaRef("typeMap");
        out.schemaRef("variableMap");
        out.schemaRef("parentScope");
        out.schemaRef("rootScope");
    }
}

