/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.treeparser;

import com.joanju.DataXferStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.prorefactor.core.schema.Field;
import org.prorefactor.core.schema.Table;
import org.prorefactor.treeparser.FieldBuffer;
import org.prorefactor.treeparser.SymbolScope;
import org.prorefactor.treeparser.SymbolScopeSuper;
import org.prorefactor.treeparser.TableBuffer;

public class SymbolScopeRoot
extends SymbolScope {
    private String className = null;
    private Map<String, Table> tableMap = new HashMap<String, Table>();

    public SymbolScopeRoot() {
        super(null);
        this.rootScope = this;
    }

    public void addTableDefinitionIfNew(Table table) {
        String lowerName = table.getName().toLowerCase();
        if (this.tableMap.get(lowerName) == null) {
            this.tableMap.put(lowerName, table);
        }
    }

    public void assignSuper(SymbolScopeRoot superScope) {
        assert (this.parentScope == null);
        this.parentScope = superScope;
    }

    public TableBuffer defineTable(String name, int type) {
        Table table = new Table(name, type);
        this.tableMap.put(name.toLowerCase(), table);
        TableBuffer bufferSymbol = new TableBuffer("", this, table);
        this.bufferMap.put(name.toLowerCase(), bufferSymbol);
        return bufferSymbol;
    }

    public FieldBuffer defineTableField(String name, TableBuffer buffer) {
        Table table = buffer.getTable();
        Field field = new Field(name, table);
        FieldBuffer fieldBuff = new FieldBuffer(this, buffer, field);
        return fieldBuff;
    }

    public FieldBuffer defineTableFieldDelayedAttach(String name, TableBuffer buffer) {
        Field field = new Field(name, null);
        FieldBuffer fieldBuff = new FieldBuffer(this, buffer, field);
        return fieldBuff;
    }

    public SymbolScopeSuper generateSymbolScopeSuper() {
        return new SymbolScopeSuper(this);
    }

    public String getClassName() {
        return this.className;
    }

    public TableBuffer getLocalTableBuffer(Table table) {
        assert (table.getStoretype() != 1102);
        return (TableBuffer)this.bufferMap.get(table.getName().toLowerCase());
    }

    public Table lookupTableDefinition(String name) {
        return this.tableMap.get(name.toLowerCase());
    }

    protected Field lookupUnqualifiedField(String name) {
        for (Table table : this.tableMap.values()) {
            Field field = table.lookupField(name);
            if (field == null) continue;
            return field;
        }
        return null;
    }

    public Map getRoutineMap() {
        return this.routineMap;
    }

    public void setClassName(String s) {
        this.className = s;
    }

    public void writeXferBytes(DataXferStream out) throws IOException {
        super.writeXferBytes(out);
        out.writeRef(this.className);
        out.writeRef(this.tableMap);
    }

    public void writeXferSchema(DataXferStream out) throws IOException {
        super.writeXferSchema(out);
        out.schemaRef("className");
        out.schemaRef("tableMap");
    }
}

