/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.treeparser;

import com.joanju.DataXferStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import org.prorefactor.core.schema.Field;
import org.prorefactor.core.schema.Schema;
import org.prorefactor.core.schema.Table;
import org.prorefactor.treeparser.FieldBuffer;
import org.prorefactor.treeparser.Symbol;
import org.prorefactor.treeparser.SymbolScope;
import org.prorefactor.treeparser.SymbolScopeRoot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableBuffer
extends Symbol {
    private boolean isDefault = false;
    private HashMap<Field, FieldBuffer> fieldBuffers = new HashMap();
    private Table table = Schema.nullTable;

    public TableBuffer() {
    }

    public TableBuffer(String name, SymbolScope scope, Table table) {
        super(scope);
        this.setName(name);
        this.table = table;
        if (name.length() == 0) {
            this.isDefault = true;
            if (table.getStoretype() != 1102) {
                this.setName(table.getName());
            }
        }
    }

    void addFieldBuffer(FieldBuffer fieldBuffer) {
        this.fieldBuffers.put(fieldBuffer.getField(), fieldBuffer);
    }

    @Override
    public Symbol copyBare(SymbolScope scope) {
        Table t;
        if (this.table.getStoretype() == 1102) {
            t = this.table;
        } else {
            SymbolScopeRoot rootScope = scope.getRootScope();
            t = rootScope.lookupTableDefinition(this.table.getName());
            if (t == null) {
                t = this.table.copyBare(rootScope);
            }
        }
        String useName = this.isDefault ? "" : super.getName();
        return new TableBuffer(useName, scope, t);
    }

    @Override
    public String fullName() {
        if (this.table.getStoretype() != 1102) {
            return this.getName();
        }
        StringBuilder buff = new StringBuilder();
        buff.append(this.table.getDatabase().getName());
        buff.append(".");
        buff.append(this.getName());
        return buff.toString();
    }

    public Collection<FieldBuffer> getFieldBufferList() {
        return this.fieldBuffers.values();
    }

    @Override
    public int getProgressType() {
        return 77;
    }

    public FieldBuffer getFieldBuffer(Field field) {
        assert (field.getTable() == this.table);
        FieldBuffer ret = this.fieldBuffers.get(field);
        if (ret != null) {
            return ret;
        }
        ret = new FieldBuffer(this.getScope(), this, field);
        this.fieldBuffers.put(field, ret);
        return ret;
    }

    @Override
    public String getName() {
        if (super.getName().length() == 0) {
            return this.table.getName();
        }
        return super.getName();
    }

    public Table getTable() {
        return this.table;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean isDefaultSchema() {
        return this.isDefault && this.table.getStoretype() == 1102;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    @Override
    public void writeXferBytes(DataXferStream out) throws IOException {
        super.writeXferBytes(out);
        out.writeRef(this.fieldBuffers);
        out.writeBool(this.isDefault);
        out.writeRef(this.table);
    }

    @Override
    public void writeXferSchema(DataXferStream out) throws IOException {
        super.writeXferSchema(out);
        out.schemaRef("fieldBuffers");
        out.schemaBool("isDefault");
        out.schemaRef("table");
    }
}

