/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.treeparser;

import com.joanju.DataXferStream;
import java.io.IOException;
import org.prorefactor.core.JPNode;
import org.prorefactor.treeparser.ClassSupport;
import org.prorefactor.treeparser.DataType;
import org.prorefactor.treeparser.Primative;
import org.prorefactor.treeparser.Symbol;
import org.prorefactor.treeparser.SymbolScope;
import org.prorefactor.treeparser.Value;

public class Variable
extends Symbol
implements Primative,
Value {
    private int extent;
    private DataType dataType;
    private Object value;
    private String className = null;

    public Variable() {
    }

    public Variable(String name, SymbolScope scope) {
        super(scope);
        this.setName(name);
    }

    public void assignAttributesLike(Primative likePrim) {
        this.dataType = likePrim.getDataType();
        this.className = likePrim.getClassName();
        this.extent = likePrim.getExtent();
    }

    public Symbol copyBare(SymbolScope scope) {
        Variable v = new Variable(this.getName(), scope);
        v.className = this.className;
        v.dataType = this.dataType;
        v.extent = this.extent;
        return v;
    }

    public String fullName() {
        return this.getName();
    }

    public String getClassName() {
        return this.className;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public int getExtent() {
        return this.extent;
    }

    public Object getValue() {
        return this.value;
    }

    public int getProgressType() {
        return 841;
    }

    public Primative setClassName(String s) {
        this.className = s;
        return this;
    }

    public Primative setClassName(JPNode typeNameNode) {
        this.className = ClassSupport.qualifiedClassName(typeNameNode);
        return this;
    }

    public Primative setDataType(DataType dataType) {
        this.dataType = dataType;
        return this;
    }

    public Primative setExtent(int extent) {
        this.extent = extent;
        return this;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void writeXferBytes(DataXferStream out) throws IOException {
        super.writeXferBytes(out);
        out.writeRef(this.className);
        out.writeRef(this.dataType);
        out.writeInt(this.extent);
    }

    public void writeXferSchema(DataXferStream out) throws IOException {
        super.writeXferSchema(out);
        out.schemaRef("className");
        out.schemaRef("dataType");
        out.schemaInt("extent");
    }
}

