/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.treeparser01;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import org.prorefactor.core.JPNode;
import org.prorefactor.core.schema.Field;
import org.prorefactor.nodetypes.BlockNode;
import org.prorefactor.nodetypes.FieldRefNode;
import org.prorefactor.nodetypes.RecordNameNode;
import org.prorefactor.treeparser.Block;
import org.prorefactor.treeparser.FieldBuffer;
import org.prorefactor.treeparser.FieldContainer;
import org.prorefactor.treeparser.FieldLookupResult;
import org.prorefactor.treeparser.Symbol;
import org.prorefactor.treeparser.SymbolScope;
import org.prorefactor.treeparser.TableBuffer;
import org.prorefactor.treeparser.Variable;
import org.prorefactor.widgettypes.Browse;
import org.prorefactor.widgettypes.Frame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameStack {
    private boolean currStatementIsEnabler = false;
    private LinkedList<Frame> frameMRU = new LinkedList();
    private FieldContainer containerForCurrentStatement = null;
    private JPNode currStatementWholeTableFormItemNode = null;

    FrameStack() {
    }

    void browseRefNode(JPNode idNode, SymbolScope symbolScope) {
        if (idNode.getSymbol() == null) {
            this.browseRefSet(idNode, symbolScope);
        }
    }

    private Browse browseRefSet(JPNode idNode, SymbolScope symbolScope) {
        Browse browse = (Browse)symbolScope.lookupFieldLevelWidget(idNode.getText());
        idNode.setLink(-210, browse);
        return browse;
    }

    public ArrayList<FieldBuffer> calculateFormItemTableFields(JPNode formItemNode) {
        assert (formItemNode.getType() == 970);
        assert (formItemNode.firstChild().getType() == 996);
        RecordNameNode recordNameNode = (RecordNameNode)formItemNode.firstChild();
        TableBuffer tableBuffer = recordNameNode.getTableBuffer();
        HashSet<Field> fieldSet = new HashSet<Field>(tableBuffer.getTable().getFieldSet());
        JPNode exceptNode = formItemNode.parent().findDirectChild(248);
        if (exceptNode != null) {
            JPNode n = exceptNode.firstChild();
            while (n != null) {
                if (n instanceof FieldRefNode) {
                    Field f = ((FieldBuffer)((FieldRefNode)n).getSymbol()).getField();
                    fieldSet.remove(f);
                }
                n = n.nextSibling();
            }
        }
        ArrayList<FieldBuffer> returnList = new ArrayList<FieldBuffer>();
        for (Field field : fieldSet) {
            returnList.add(tableBuffer.getFieldBuffer(field));
        }
        return returnList;
    }

    private Frame createFrame(String frameName, SymbolScope symbolScope) {
        Frame frame = new Frame(frameName, symbolScope);
        this.frameMRU.addFirst(frame);
        return frame;
    }

    void formItem(JPNode formItemNode) {
        if (this.containerForCurrentStatement == null) {
            return;
        }
        assert (formItemNode.getType() == 970);
        JPNode firstChild = formItemNode.firstChild();
        if (firstChild.getType() == 996) {
            this.currStatementWholeTableFormItemNode = formItemNode;
        } else {
            FieldRefNode fieldRefNode = null;
            JPNode tempNode = formItemNode.findDirectChild(971);
            if (tempNode != null && (tempNode = tempNode.findDirectChild(885)) != null) {
                return;
            }
            if (fieldRefNode == null && firstChild.getType() == 969) {
                fieldRefNode = (FieldRefNode)firstChild;
            }
            if (fieldRefNode != null) {
                this.containerForCurrentStatement.addSymbol(fieldRefNode.getSymbol(), this.currStatementIsEnabler);
            }
        }
    }

    void frameRefNode(JPNode idNode, SymbolScope symbolScope) {
        if (idNode.getSymbol() == null) {
            this.frameRefSet(idNode, symbolScope);
        }
    }

    private Frame frameRefSet(JPNode idNode, SymbolScope symbolScope) {
        String frameName = idNode.getText();
        Frame frame = (Frame)symbolScope.lookupWidget(296, frameName);
        if (frame == null) {
            frame = this.createFrame(frameName, symbolScope);
        }
        idNode.setLink(-210, frame);
        return frame;
    }

    private JPNode getContainerTypeNode(JPNode stateNode) {
        JPNode withNode = stateNode.findDirectChild(867);
        if (withNode == null) {
            return null;
        }
        JPNode typeNode = withNode.findDirectChild(296);
        if (typeNode == null) {
            typeNode = withNode.findDirectChild(75);
        }
        return typeNode;
    }

    private Frame initializeFrame(Frame frame, Block currentBlock) {
        boolean newFrame;
        if (frame == null) {
            frame = currentBlock.getDefaultFrame();
        }
        boolean bl = newFrame = frame == null;
        if (newFrame) {
            frame = this.createFrame("", currentBlock.getSymbolScope());
            frame.setFrameScopeUnnamedDefault(currentBlock);
        }
        if (!frame.isInitialized()) {
            frame.initialize(currentBlock);
            if (!newFrame) {
                this.frameMRU.remove(frame);
                this.frameMRU.addFirst(frame);
            }
        }
        return frame;
    }

    FieldLookupResult inputFieldLookup(FieldRefNode fieldRefNode, SymbolScope currentScope) {
        JPNode idNode = fieldRefNode.getIdNode();
        Field.Name inputName = new Field.Name(idNode.getText().toLowerCase());
        FieldContainer fieldContainer = null;
        Symbol fieldOrVariable = null;
        JPNode tempNode = fieldRefNode.firstChild();
        int tempType = tempNode.getType();
        if (tempType == 382) {
            tempNode = tempNode.nextSibling();
            tempType = tempNode.getType();
        }
        if (tempType == 75 || tempType == 296) {
            fieldContainer = (FieldContainer)tempNode.nextNode().getSymbol();
            fieldOrVariable = fieldContainer.lookupFieldOrVar(inputName);
        } else {
            for (Frame frame : this.frameMRU) {
                if (!frame.getScope().isActiveIn(currentScope) || (fieldOrVariable = frame.lookupFieldOrVar(inputName)) == null) continue;
                fieldContainer = frame;
                break;
            }
        }
        if (fieldOrVariable == null) {
            throw new Error("Could not find input field " + idNode.getText() + " " + idNode.getFilename() + ":" + idNode.getLine());
        }
        fieldRefNode.setFieldContainer(fieldContainer);
        FieldLookupResult result = new FieldLookupResult();
        if (fieldOrVariable instanceof Variable) {
            result.variable = (Variable)fieldOrVariable;
        } else {
            result.field = (FieldBuffer)fieldOrVariable;
            Field.Name resName = new Field.Name(fieldOrVariable.fullName());
            if (inputName.table == null) {
                result.isUnqualified = true;
            }
            if (inputName.field.length() < resName.field.length() || inputName.table != null && inputName.table.length() < resName.table.length()) {
                result.isAbbreviated = true;
            }
        }
        return result;
    }

    void lexAt(JPNode fieldRefNode) {
        if (this.containerForCurrentStatement != null) {
            this.containerForCurrentStatement.addSymbol(fieldRefNode.getSymbol(), this.currStatementIsEnabler);
        }
    }

    void nodeOfBlock(JPNode blockNode, Block currentBlock) {
        JPNode containerTypeNode = this.getContainerTypeNode(blockNode);
        if (containerTypeNode == null) {
            return;
        }
        assert (containerTypeNode.getType() == 296);
        JPNode frameIDNode = containerTypeNode.nextNode();
        assert (frameIDNode.getType() == 913);
        Frame frame = this.frameRefSet(frameIDNode, currentBlock.getSymbolScope());
        frame.setFrameScopeBlockExplicitDefault(((BlockNode)blockNode).getBlock());
        blockNode.setFieldContainer(frame);
        this.containerForCurrentStatement = frame;
    }

    void nodeOfDefineBrowse(Browse newBrowseSymbol, JPNode defNode) {
        this.containerForCurrentStatement = newBrowseSymbol;
        this.containerForCurrentStatement.addStatement(defNode);
    }

    void nodeOfDefineFrame(JPNode defNode, JPNode idNode, SymbolScope currentSymbolScope) {
        String frameName = idNode.getText();
        Frame frame = (Frame)currentSymbolScope.lookupSymbolLocally(296, frameName);
        if (frame == null) {
            frame = this.createFrame(frameName, currentSymbolScope);
        }
        frame.setDefOrIdNode(defNode);
        idNode.setLink(-210, frame);
        defNode.setFieldContainer(frame);
        this.containerForCurrentStatement = frame;
        this.containerForCurrentStatement.addStatement(defNode);
    }

    void nodeOfInitializingStatement(JPNode stateNode, Block currentBlock) {
        JPNode containerTypeNode = this.getContainerTypeNode(stateNode);
        JPNode idNode = null;
        if (containerTypeNode != null) {
            idNode = containerTypeNode.nextNode();
            assert (idNode.getType() == 913);
        }
        if (containerTypeNode != null && containerTypeNode.getType() == 75) {
            this.containerForCurrentStatement = this.browseRefSet(idNode, currentBlock.getSymbolScope());
        } else {
            Frame frame = null;
            if (idNode != null) {
                frame = this.frameRefSet(idNode, currentBlock.getSymbolScope());
            }
            frame = this.initializeFrame(frame, currentBlock);
            this.containerForCurrentStatement = frame;
        }
        stateNode.setFieldContainer(this.containerForCurrentStatement);
        this.containerForCurrentStatement.addStatement(stateNode);
    }

    void simpleFrameInitStatement(JPNode headNode, JPNode frameIDNode, Block currentBlock) {
        Frame frame = (Frame)frameIDNode.getSymbol();
        assert (frame != null);
        this.initializeFrame(frame, currentBlock);
        headNode.setFieldContainer(frame);
        frame.addStatement(headNode);
    }

    void statementEnd() {
        if (this.currStatementWholeTableFormItemNode != null) {
            ArrayList<FieldBuffer> fields = this.calculateFormItemTableFields(this.currStatementWholeTableFormItemNode);
            for (FieldBuffer fieldBuffer : fields) {
                this.containerForCurrentStatement.addSymbol(fieldBuffer, this.currStatementIsEnabler);
            }
            this.currStatementWholeTableFormItemNode = null;
        }
        this.containerForCurrentStatement = null;
        this.currStatementIsEnabler = false;
    }

    public void statementIsEnabler() {
        this.currStatementIsEnabler = true;
    }
}

