/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.treeparser01;

import antlr.SemanticException;
import antlr.collections.AST;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import org.prorefactor.core.JPNode;
import org.prorefactor.core.TokenTypes;
import org.prorefactor.core.schema.Field;
import org.prorefactor.core.schema.Schema;
import org.prorefactor.core.schema.Table;
import org.prorefactor.nodetypes.BlockNode;
import org.prorefactor.nodetypes.FieldRefNode;
import org.prorefactor.nodetypes.RecordNameNode;
import org.prorefactor.refactor.FileStuff;
import org.prorefactor.refactor.PUB;
import org.prorefactor.refactor.RefactorSession;
import org.prorefactor.treeparser.Block;
import org.prorefactor.treeparser.BufferScope;
import org.prorefactor.treeparser.Call;
import org.prorefactor.treeparser.DataType;
import org.prorefactor.treeparser.Dataset;
import org.prorefactor.treeparser.ErrorList;
import org.prorefactor.treeparser.Event;
import org.prorefactor.treeparser.Expression;
import org.prorefactor.treeparser.FieldBuffer;
import org.prorefactor.treeparser.FieldLookupResult;
import org.prorefactor.treeparser.Parameter;
import org.prorefactor.treeparser.ParseUnit;
import org.prorefactor.treeparser.Primative;
import org.prorefactor.treeparser.Routine;
import org.prorefactor.treeparser.Symbol;
import org.prorefactor.treeparser.SymbolFactory;
import org.prorefactor.treeparser.SymbolScope;
import org.prorefactor.treeparser.SymbolScopeRoot;
import org.prorefactor.treeparser.SymbolScopeSuper;
import org.prorefactor.treeparser.TableBuffer;
import org.prorefactor.treeparser.Variable;
import org.prorefactor.treeparser01.FrameStack;
import org.prorefactor.treeparser01.TP01Action;
import org.prorefactor.widgettypes.Browse;

public class TP01Support
extends TP01Action {
    private ArrayList<Block> blockStack = new ArrayList();
    private Block currentBlock;
    private ErrorList errorList = new ErrorList();
    private Expression wipExpression;
    private FrameStack frameStack = new FrameStack();
    private HashMap<String, SymbolScope> funcForwards = new HashMap();
    private LinkedList<Call> wipCalls = new LinkedList();
    private LinkedList<Parameter> wipParameters = new LinkedList();
    private Routine currentRoutine;
    private Routine rootRoutine;
    private Schema schema = Schema.getInstance();
    private Symbol currSymbol;
    SymbolScope currentScope;
    SymbolScopeRoot rootScope = new SymbolScopeRoot();
    TableBuffer lastTableReferenced;
    TableBuffer prevTableReferenced;
    TableBuffer currDefTable;

    public TP01Support() {
        this.currentScope = this.rootScope;
    }

    public void addToSymbolScope(Object o) {
        this.currentScope.add((Symbol)o);
    }

    private Table astTableLink(AST tableAST) {
        TableBuffer buffer = (TableBuffer)((JPNode)tableAST).getLink(-210);
        assert (buffer != null);
        return buffer.getTable();
    }

    public void blockBegin(AST blockAST) {
        BlockNode blockNode = (BlockNode)blockAST;
        this.currentBlock = this.pushBlock(new Block(this.currentBlock, (JPNode)blockNode));
        blockNode.setBlock(this.currentBlock);
    }

    public void blockEnd() {
        this.currentBlock = this.popBlock();
    }

    protected void browseRef(AST idAST) {
        this.frameStack.browseRefNode((JPNode)idAST, this.currentScope);
    }

    protected void callBegin(AST callAST) {
        JPNode callNode = (JPNode)callAST;
        Call call = new Call(callNode);
        callNode.setCall(call);
        this.wipCalls.addFirst(call);
    }

    protected void callEnd() {
        this.currentScope.registerCall(this.wipCalls.getFirst());
        this.wipCalls.removeFirst();
    }

    protected void canFindBegin(AST canfindAST, AST recordAST) {
        Table table;
        RecordNameNode recordNode = (RecordNameNode)recordAST;
        Block b = this.currentBlock;
        this.scopeAdd(canfindAST);
        this.currentBlock.setParent(b);
        String buffName = recordAST.getText();
        boolean isDefault = false;
        TableBuffer tableBuffer = this.currentScope.lookupBuffer(buffName);
        if (tableBuffer != null) {
            table = tableBuffer.getTable();
            isDefault = tableBuffer.isDefault();
        } else {
            table = this.schema.lookupTable(buffName);
            isDefault = true;
        }
        TableBuffer newBuff = this.currentScope.defineBuffer(isDefault ? "" : buffName, table);
        recordNode.setTableBuffer(newBuff);
        this.currentBlock.addHiddenCursor(recordNode);
    }

    protected void canFindEnd(AST canfindAST) {
        this.scopeClose(canfindAST);
    }

    protected void classState(AST classAST) {
        JPNode classNode = (JPNode)classAST;
        JPNode idNode = classNode.firstChild();
        this.rootScope.setClassName(idNode.getText());
        if (idNode.nextSibling().getType() == 1110) {
            this.classStateInherits(classNode, idNode.nextSibling().firstChild());
        }
    }

    private void classStateInherits(JPNode classNode, JPNode inheritsTypeNode) {
        String className = inheritsTypeNode.attrGetS("qualified-class");
        SymbolScopeSuper cachedCopy = SymbolScopeSuper.cache.get(className.toLowerCase());
        if (cachedCopy == null) {
            cachedCopy = this.classStateSuper(classNode, className);
        }
        if (cachedCopy != null) {
            SymbolScopeSuper.cache.put(className.toLowerCase(), cachedCopy);
            this.rootScope.assignSuper(cachedCopy.generateSymbolScopeSuper());
        }
    }

    private SymbolScopeSuper classStateSuper(JPNode classNode, String className) {
        File file = FileStuff.findFileForClassName(className);
        if (file == null || !file.exists()) {
            return null;
        }
        PUB pub = new PUB(FileStuff.fullpath(file));
        boolean pubIsCurrent = pub.loadTo(15);
        ParseUnit pu = new ParseUnit(file);
        pu.setPUB(pub);
        JPNode superClassTree = (JPNode)classNode.getLink(-219);
        try {
            if (superClassTree != null) {
                pu.setTopNode(superClassTree);
            } else {
                if (!pubIsCurrent) {
                    throw new Error("Internal error: No tree from PUB or Proparse, for class: " + className);
                }
                pub.load();
                pu.setTopNode(pub.getTree());
            }
            pu.treeParser01();
        }
        catch (Exception e) {
            throw new Error(e);
        }
        return pu.getRootScope().generateSymbolScopeSuper();
    }

    protected void clearState(AST headAST) {
        JPNode headNode = (JPNode)headAST;
        JPNode firstChild = headNode.firstChild();
        if (firstChild.getType() == 296) {
            this.frameStack.simpleFrameInitStatement(headNode, firstChild.nextNode(), this.currentBlock);
        }
    }

    protected void datasetTable(AST tableAST) {
        RecordNameNode tableNode = (RecordNameNode)tableAST;
        Dataset dataset = (Dataset)this.currSymbol;
        dataset.addBuffer(tableNode.getTableBuffer());
    }

    protected void defAs(AST asAST) {
        JPNode asNode = (JPNode)asAST;
        this.currSymbol.setAsNode(asNode);
        Primative primative = (Primative)((Object)this.currSymbol);
        JPNode typeNode = asNode.nextNode();
        if (typeNode.getType() == 1101) {
            typeNode = typeNode.nextNode();
        }
        if (typeNode.getType() == 1125) {
            primative.setDataType(DataType.getDataType(1101));
            primative.setClassName(typeNode);
        } else {
            primative.setDataType(DataType.getDataType(typeNode.getType()));
        }
        assert (primative.getDataType() != null) : "Failed to set datatype at " + asNode.getFilename() + " line " + asNode.getLine();
    }

    protected void defExtent(AST extentAST) {
        JPNode extentNode = (JPNode)extentAST;
        Primative primative = (Primative)((Object)this.currSymbol);
        JPNode exprNode = extentNode.firstChild();
        if (exprNode == null || exprNode.getType() != 6) {
            primative.setExtent(-1);
        } else {
            primative.setExtent(Integer.parseInt(exprNode.getText()));
        }
    }

    protected void defLike(AST likeAST) {
        JPNode likeNode = (JPNode)likeAST;
        this.currSymbol.setLikeNode(likeNode);
        Primative likePrim = (Primative)((Object)likeNode.nextNode().getSymbol());
        Primative newPrim = (Primative)((Object)this.currSymbol);
        newPrim.assignAttributesLike(likePrim);
        assert (newPrim.getDataType() != null) : "Failed to set datatype at " + likeNode.getFilename() + " line " + likeNode.getLine();
    }

    protected Browse defineBrowse(AST defAST, AST idAST) {
        Browse browse = (Browse)this.defineSymbol(75, defAST, idAST);
        this.frameStack.nodeOfDefineBrowse(browse, (JPNode)defAST);
        return browse;
    }

    protected void defineBuffer(AST defAST, AST idAST, AST tableAST, boolean init) {
        JPNode idNode = (JPNode)idAST;
        Table table = this.astTableLink(tableAST);
        TableBuffer bufSymbol = this.currentScope.defineBuffer(idNode.getText(), table);
        this.currSymbol = bufSymbol;
        bufSymbol.setDefOrIdNode((JPNode)defAST);
        idNode.setLink(-210, bufSymbol);
        if (init) {
            BufferScope bufScope = this.currentBlock.getBufferForReference(bufSymbol);
            idNode.setLink(-212, bufScope);
        }
    }

    protected void defineBufferForTrigger(AST tableAST) {
        Table table = this.astTableLink(tableAST);
        TableBuffer bufSymbol = this.currentScope.defineBuffer("", table);
        this.currentBlock.getBufferForReference(bufSymbol);
        this.currSymbol = bufSymbol;
    }

    protected Event defineEvent(AST defAST, AST idAST) {
        JPNode defNode = (JPNode)defAST;
        JPNode idNode = (JPNode)idAST;
        String name = idNode.getText();
        if (name == null || name.length() == 0) {
            name = TokenTypes.getTokenName(idNode.getType());
        }
        Event event = new Event(name, this.currentScope);
        event.setDefOrIdNode(defNode);
        this.currSymbol = event;
        idNode.setLink(-210, event);
        return event;
    }

    protected Symbol defineSymbol(int symbolType, AST defAST, AST idAST) {
        JPNode defNode = (JPNode)defAST;
        JPNode idNode = (JPNode)idAST;
        Symbol symbol = SymbolFactory.create(symbolType, idNode.getText(), this.currentScope);
        symbol.setDefOrIdNode(defNode);
        this.currSymbol = symbol;
        idNode.setLink(-210, symbol);
        return symbol;
    }

    protected Object defineTableFieldInitialize(AST idAST) {
        JPNode idNode = (JPNode)idAST;
        FieldBuffer fieldBuff = this.rootScope.defineTableFieldDelayedAttach(idNode.getText(), this.currDefTable);
        this.currSymbol = fieldBuff;
        fieldBuff.setDefOrIdNode(idNode);
        idNode.setLink(-210, fieldBuff);
        return fieldBuff;
    }

    protected void defineTableFieldFinalize(Object obj) {
        ((FieldBuffer)obj).getField().setTable(this.currDefTable.getTable());
    }

    protected void defineTableLike(AST tableAST) {
        Table table = this.astTableLink(tableAST);
        for (Field field : table.getFieldPosOrder()) {
            this.rootScope.defineTableField(field.getName(), this.currDefTable).assignAttributesLike(field);
        }
    }

    protected void defineTable(JPNode defNode, JPNode idNode, int storeType) {
        TableBuffer buffer = this.rootScope.defineTable(idNode.getText(), storeType);
        buffer.setDefOrIdNode(defNode);
        this.currSymbol = buffer;
        this.currDefTable = buffer;
        idNode.setLink(-210, buffer);
    }

    protected void defineTemptable(AST defAST, AST idAST) {
        this.defineTable((JPNode)defAST, (JPNode)idAST, 1103);
    }

    protected Variable defineVariable(AST defAST, AST idAST) {
        JPNode defNode = (JPNode)defAST;
        JPNode idNode = (JPNode)idAST;
        String name = idNode.getText();
        if (name == null || name.length() == 0) {
            name = TokenTypes.getTokenName(idNode.getType());
        }
        Variable variable = new Variable(name, this.currentScope);
        variable.setDefOrIdNode(defNode);
        this.currSymbol = variable;
        idNode.setLink(-210, variable);
        return variable;
    }

    protected Variable defineVariable(AST defAST, AST idAST, int dataType) {
        assert (dataType != 1101);
        Variable v = this.defineVariable(defAST, idAST);
        v.setDataType(DataType.getDataType(dataType));
        return v;
    }

    protected Variable defineVariable(AST defAST, AST idAST, AST likeAST) {
        Variable v = this.defineVariable(defAST, idAST);
        FieldRefNode likeRefNode = (FieldRefNode)likeAST;
        v.setDataType(likeRefNode.getDataType());
        v.setClassName(likeRefNode.getClassName());
        return v;
    }

    protected void defineWorktable(AST defAST, AST idAST) {
        this.defineTable((JPNode)defAST, (JPNode)idAST, 1104);
    }

    protected void field(AST refAST, AST idAST, int contextQualifier, int whichTable) {
        JPNode idNode = (JPNode)idAST;
        FieldRefNode refNode = (FieldRefNode)refAST;
        String name = idNode.getText();
        FieldLookupResult result = null;
        refNode.attrSet(10160, contextQualifier);
        if (refNode.attrGet(2000) == 1) {
            this.addToSymbolScope(this.defineVariable(idAST, idAST));
        }
        if (refNode.parent().getType() == 833 && refNode.parent().parent().getType() == 996 || refNode.firstChild().getType() == 382 && (refNode.nextSibling() == null || refNode.nextSibling().getType() != 7)) {
            result = this.frameStack.inputFieldLookup(refNode, this.currentScope);
        } else if (whichTable == 0) {
            boolean getBufferScope = contextQualifier != 4;
            result = this.currentBlock.lookupField(name, getBufferScope);
        } else {
            String[] parts = name.split("\\.");
            String fieldPart = parts[parts.length - 1];
            TableBuffer ourBuffer = whichTable == 2 ? this.prevTableReferenced : this.lastTableReferenced;
            Field field = ourBuffer.getTable().lookupField(fieldPart);
            if (field == null) {
                int parentType = refNode.parent().getType();
                if (parentType == 266 || parentType == 248) {
                    return;
                }
                throw new Error(String.valueOf(idNode.getFilename()) + ":" + idNode.getLine() + " Unknown field or variable name: " + fieldPart);
            }
            FieldBuffer fieldBuffer = ourBuffer.getFieldBuffer(field);
            result = new FieldLookupResult();
            result.field = fieldBuffer;
        }
        if (result == null) {
            return;
        }
        if (result.isUnqualified) {
            refNode.attrSet(10150, 1);
        }
        if (result.isAbbreviated) {
            refNode.attrSet(1700, 1);
        }
        if (result.variable != null) {
            refNode.setSymbol(result.variable);
            refNode.attrSet(1100, 1105);
            result.variable.noteReference(contextQualifier);
        }
        if (result.fieldLevelWidget != null) {
            refNode.setSymbol(result.fieldLevelWidget);
            refNode.attrSet(1100, 1105);
            result.fieldLevelWidget.noteReference(contextQualifier);
        }
        if (result.bufferScope != null) {
            refNode.setBufferScope(result.bufferScope);
        }
        if (result.field != null) {
            refNode.setSymbol(result.field);
            refNode.attrSet(1100, result.field.getField().getTable().getStoretype());
            result.field.noteReference(contextQualifier);
        }
        if (result.event != null) {
            refNode.setSymbol(result.event);
            refNode.attrSet(1100, 1105);
            result.event.noteReference(contextQualifier);
        }
    }

    protected void fnvExpression(AST node) {
        this.wipExpression = new Expression((JPNode)node);
    }

    protected void fnvFilename(AST node) {
        Expression exp = new Expression((JPNode)node);
        exp.setValue(node.getText());
        this.wipExpression = exp;
    }

    protected void formItem(AST ast) {
        this.frameStack.formItem((JPNode)ast);
    }

    protected void frameBlockCheck(AST ast) {
        this.frameStack.nodeOfBlock((JPNode)ast, this.currentBlock);
    }

    protected void frameDef(AST defAST, AST idAST) {
        this.frameStack.nodeOfDefineFrame((JPNode)defAST, (JPNode)idAST, this.currentScope);
    }

    protected void frameEnablingStatement(AST ast) {
        this.frameStack.statementIsEnabler();
        this.frameStack.nodeOfInitializingStatement((JPNode)ast, this.currentBlock);
    }

    protected void frameInitializingStatement(AST ast) {
        this.frameStack.nodeOfInitializingStatement((JPNode)ast, this.currentBlock);
    }

    protected void frameStatementEnd() {
        this.frameStack.statementEnd();
    }

    protected void frameRef(AST idAST) {
        this.frameStack.frameRefNode((JPNode)idAST, this.currentScope);
    }

    protected void funcBegin(AST funcAST, AST idAST) {
        this.scopeAdd(funcAST);
        JPNode idNode = (JPNode)idAST;
        BlockNode blockNode = (BlockNode)idNode.parent();
        SymbolScope definingScope = this.currentScope.getParentScope();
        Routine r = new Routine(idAST.getText(), definingScope, this.currentScope);
        r.setProgressType(310);
        r.setDefOrIdNode(blockNode);
        blockNode.setSymbol(r);
        definingScope.add(r);
        this.currentRoutine = r;
    }

    protected void funcDef(AST funcAST, AST idAST) {
        if (this.currentRoutine.getParameters().size() > 0) {
            return;
        }
        SymbolScope forwardScope = this.funcForwards.get(idAST.getText());
        if (forwardScope != null) {
            Routine routine = (Routine)forwardScope.getRootBlock().getNode().getSymbol();
            this.scopeSwap(forwardScope);
            BlockNode blocknode = (BlockNode)funcAST;
            blocknode.setBlock(this.currentBlock);
            blocknode.setSymbol(routine);
            routine.setDefOrIdNode(blocknode);
            this.currentRoutine = routine;
        }
    }

    protected void funcEnd(AST funcAST) {
        this.scopeClose(funcAST);
        this.currentRoutine = this.rootRoutine;
    }

    protected void funcForward(AST idAST) {
        this.funcForwards.put(idAST.getText(), this.currentScope);
    }

    public SymbolScope getCurrentScope() {
        return this.currentScope;
    }

    public ErrorList getErrorList() {
        return this.errorList;
    }

    public SymbolScopeRoot getRootScope() {
        return this.rootScope;
    }

    protected void lexat(AST fieldRefAST) {
        this.frameStack.lexAt((JPNode)fieldRefAST);
    }

    protected void methodBegin(AST blockAST, AST idAST) {
        this.scopeAdd(blockAST);
        JPNode idNode = (JPNode)idAST;
        BlockNode blockNode = (BlockNode)idNode.parent();
        SymbolScope definingScope = this.currentScope.getParentScope();
        Routine r = new Routine(idAST.getText(), definingScope, this.currentScope);
        r.setProgressType(1112);
        r.setDefOrIdNode(blockNode);
        blockNode.setSymbol(r);
        definingScope.add(r);
        this.currentRoutine = r;
    }

    protected void methodEnd(AST blockAST) {
        this.scopeClose(blockAST);
        this.currentRoutine = this.rootRoutine;
    }

    protected void paramBind() {
        this.wipParameters.getFirst().setBind(true);
    }

    protected void paramEnd() {
        this.wipParameters.removeFirst();
    }

    protected void paramExpression(AST exprAST) {
        JPNode exprNode = (JPNode)exprAST;
        this.wipParameters.getFirst().setSymbol(exprNode.getSymbol());
    }

    protected void paramForCall(AST directionAST) {
        Parameter param = new Parameter();
        param.setDirectionNode((JPNode)directionAST);
        this.wipParameters.addFirst(param);
        this.wipCalls.getFirst().addParameter(param);
    }

    protected void paramForRoutine(AST directionAST) {
        Parameter param = new Parameter();
        param.setDirectionNode((JPNode)directionAST);
        this.wipParameters.addFirst(param);
        this.currentRoutine.addParameter(param);
    }

    protected void paramNoName(AST datatypeAST) {
        Variable variable = new Variable("", this.currentScope);
        this.currSymbol = variable;
        JPNode typeNode = (JPNode)datatypeAST;
        if (typeNode.getType() == 1101) {
            typeNode = typeNode.nextNode();
        }
        if (typeNode.getType() == 1125) {
            variable.setDataType(DataType.getDataType(1101));
            variable.setClassName(typeNode);
        } else {
            variable.setDataType(DataType.getDataType(typeNode.getType()));
        }
    }

    protected void paramProgressType(int progressType) {
        this.wipParameters.getFirst().setProgressType(progressType);
    }

    protected void paramSymbol(AST symbolAST) {
        this.wipParameters.getFirst().setSymbol(((JPNode)symbolAST).getSymbol());
    }

    protected Block popBlock() {
        this.blockStack.remove(this.blockStack.size() - 1);
        return this.blockStack.get(this.blockStack.size() - 1);
    }

    protected void procedureBegin(AST procAST, AST idAST) {
        BlockNode blockNode = (BlockNode)procAST;
        SymbolScope definingScope = this.currentScope;
        this.scopeAdd((AST)blockNode);
        Routine r = new Routine(idAST.getText(), definingScope, this.currentScope);
        r.setProgressType(600);
        r.setDefOrIdNode(blockNode);
        blockNode.setSymbol(r);
        definingScope.add(r);
        this.currentRoutine = r;
    }

    protected void procedureEnd(AST node) {
        this.scopeClose(node);
        this.currentRoutine = this.rootRoutine;
    }

    protected void programRoot(AST rootAST) {
        BlockNode blockNode = (BlockNode)rootAST;
        this.currentBlock = this.pushBlock(new Block(this.rootScope, (JPNode)blockNode));
        this.rootScope.setRootBlock(this.currentBlock);
        blockNode.setBlock(this.currentBlock);
        this.parseUnit.setTopNode(blockNode);
        this.parseUnit.setRootScope(this.rootScope);
        Routine r = new Routine("", this.rootScope, this.rootScope);
        r.setProgressType(979);
        r.setDefOrIdNode(blockNode);
        blockNode.setSymbol(r);
        this.rootScope.add(r);
        this.currentRoutine = r;
        this.rootRoutine = r;
    }

    protected void programTail() {
        if (RefactorSession.getInstance().getProjectBinaraiesEnabled()) {
            try {
                PUB pub = this.parseUnit.getPUB();
                if (!pub.isChecked()) {
                    pub.loadTo(15);
                }
                if (!pub.isCurrent()) {
                    pub.build(this);
                }
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }
        ArrayList<SymbolScope> allScopes = new ArrayList<SymbolScope>();
        allScopes.add(this.rootScope);
        allScopes.addAll(this.rootScope.getChildScopesDeep());
        LinkedList<Call> calls = new LinkedList<Call>();
        for (SymbolScope scope : allScopes) {
            for (Call call : scope.getCallList()) {
                if (call.isInHandle()) {
                    calls.addLast(call);
                    continue;
                }
                calls.addFirst(call);
            }
        }
        for (Call call : calls) {
            try {
                String routineId = call.getRunArgument();
                call.wrapUp(this.rootScope.hasRoutine(routineId));
            }
            catch (SemanticException e) {
                throw new RuntimeException("Unhandled SemanticException.");
            }
        }
    }

    protected Block pushBlock(Block block) {
        this.blockStack.add(block);
        return block;
    }

    private void recordNodeSymbol(JPNode node, TableBuffer buffer) {
        String nodeText = node.getText();
        if (buffer == null) {
            throw new Error(String.valueOf(node.getFilename()) + ":" + node.getLine() + " Could not resolve table: " + nodeText);
        }
        Table table = buffer.getTable();
        if (table.getStoretype() != node.attrGet(1100)) {
            throw new Error(String.valueOf(node.getFilename()) + ":" + node.getLine() + " Storetype mismatch between proparse.dll and treeparser01: " + nodeText + " " + node.attrGet(1100) + " " + table.getStoretype());
        }
        this.prevTableReferenced = this.lastTableReferenced;
        this.lastTableReferenced = buffer;
        if (buffer.isDefault() && table.getStoretype() == 1102) {
            String[] nameParts = nodeText.split("\\.");
            int tableNameLen = nameParts[nameParts.length - 1].length();
            if (table.getName().length() > tableNameLen) {
                node.attrSet(1700, 1);
            }
        }
    }

    protected void recordNameNode(AST anode, int contextQualifier) {
        RecordNameNode recordNode = (RecordNameNode)anode;
        recordNode.attrSet(10160, contextQualifier);
        TableBuffer buffer = null;
        switch (contextQualifier) {
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 12: 
            case 15: {
                buffer = this.currentScope.getBufferSymbol(recordNode.getText());
                break;
            }
            case 4: {
                buffer = this.currentScope.lookupTableOrBufferSymbol(anode.getText());
                break;
            }
            case 13: {
                buffer = this.currentScope.lookupTempTable(anode.getText());
                break;
            }
            case 14: {
                Table table = this.schema.lookupTable(anode.getText());
                if (table == null) break;
                buffer = this.currentScope.getUnnamedBuffer(table);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.recordNodeSymbol(recordNode, buffer);
        recordNode.setTableBuffer(buffer);
        switch (contextQualifier) {
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                recordNode.setBufferScope(this.currentBlock.getBufferForReference(buffer));
                break;
            }
            case 15: {
                recordNode.setBufferScope(this.currentBlock.addWeakBufferScope(buffer));
            }
        }
        buffer.noteReference(contextQualifier);
    }

    protected void routineReturnDatatype(AST datatypeAST) {
        JPNode datatypeNode = (JPNode)datatypeAST;
        if (datatypeNode.getType() == 1101) {
            datatypeNode = datatypeNode.nextNode();
        }
        this.currentRoutine.setReturnDatatypeNode(datatypeNode);
    }

    protected void runBegin(AST runAST) {
        JPNode runNode = (JPNode)runAST;
        String fileName = (String)this.wipExpression.getValue();
        Call call = new Call(runNode);
        call.setRunArgument(fileName);
        runNode.setCall(call);
        this.wipCalls.addFirst(call);
    }

    protected void runEnd(AST node) {
        this.currentScope.registerCall(this.wipCalls.getFirst());
        this.wipCalls.removeFirst();
    }

    protected void runInHandle(AST exprNode) {
        this.wipCalls.getFirst().setRunHandleNode((JPNode)exprNode);
    }

    protected void runPersistentSet(AST fld) {
        this.wipCalls.getFirst().setPersistentHandleNode((JPNode)fld);
    }

    protected void scopeAdd(AST anode) {
        BlockNode blockNode = (BlockNode)anode;
        this.currentScope = this.currentScope.addScope();
        this.currentBlock = this.pushBlock(new Block(this.currentScope, (JPNode)blockNode));
        this.currentScope.setRootBlock(this.currentBlock);
        blockNode.setBlock(this.currentBlock);
    }

    protected void scopeClose(AST scopeRootNode) {
        this.currentScope = this.currentScope.getParentScope();
        this.blockEnd();
    }

    private void scopeSwap(SymbolScope scope) {
        this.currentScope = scope;
        this.blockEnd();
        this.currentBlock = this.pushBlock(scope.getRootBlock());
    }

    protected void setSymbol(int symbolType, AST idAST) {
        JPNode idNode = (JPNode)idAST;
        idNode.setSymbol(this.currentScope.lookupSymbol(symbolType, idNode.getText()));
    }

    protected void strongScope(AST anode) {
        this.currentBlock.addStrongBufferScope((RecordNameNode)anode);
    }

    protected void structorBegin(AST blockAST) {
        this.scopeAdd(blockAST);
        BlockNode blockNode = (BlockNode)blockAST;
        SymbolScope definingScope = this.currentScope.getParentScope();
        Routine r = new Routine("", definingScope, this.currentScope);
        r.setProgressType(blockNode.getType());
        r.setDefOrIdNode(blockNode);
        blockNode.setSymbol(r);
        this.currentRoutine = r;
    }

    protected void structorEnd(AST blockAST) {
        this.scopeClose(blockAST);
        this.currentRoutine = this.rootRoutine;
    }

    protected void viewState(AST headAST) {
        JPNode headNode = (JPNode)headAST;
        for (JPNode frameNode : headNode.query(296)) {
            int parentType = frameNode.parent().getType();
            if (parentType != 988 && parentType != 368) continue;
            this.frameStack.simpleFrameInitStatement(headNode, frameNode.nextNode(), this.currentBlock);
            return;
        }
    }
}

