/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.treeparserbase;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class PostProcessor {
    public static void main(String[] args) {
        System.out.println("PostProcessor is processing " + args[0]);
        try {
            PostProcessor.trimTokenNames(args[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("PostProcessor is done.");
    }

    public static void trimTokenNames(String inName) throws IOException {
        String line;
        File origFile = new File(inName);
        File tempFile = new File(String.valueOf(inName) + ".temp");
        BufferedReader reader = new BufferedReader(new FileReader(origFile));
        BufferedWriter writer = new BufferedWriter(new FileWriter(tempFile));
        while ((line = reader.readLine()) != null) {
            if (line.equals("\tpublic static final String[] _tokenNames = {")) {
                writer.write("\tpublic static final String[] _tokenNames = { };");
                while (!reader.readLine().equals("\t};")) {
                }
            } else {
                writer.write(line);
            }
            writer.newLine();
        }
        reader.close();
        writer.close();
        origFile.delete();
        if (!tempFile.renameTo(origFile)) {
            throw new IOException("Failed to rename " + tempFile.getName() + " to " + origFile.getName());
        }
    }
}

