/*
 * Decompiled with CFR 0.152.
 */
package proparse;

import com.joanju.proparse.sockets.SocketListener;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Properties;
import org.prorefactor.refactor.RefactorSession;

public class Server {
    private static int port = 55001;
    private static String projectName = null;

    public static void main(String[] args) {
        try {
            Server.loadProperties();
            RefactorSession rsession = RefactorSession.getInstance();
            if (projectName != null && projectName.length() != 0) {
                System.out.println("Proparse Server is loading project " + projectName);
                rsession.loadProject(projectName);
            } else {
                System.out.println("Proparse Server not configured with any project.");
            }
            ServerSocket serverSocket = new ServerSocket(port);
            System.out.println("Proparse Server is listening on socket " + port);
            while (true) {
                Socket socket = serverSocket.accept();
                SocketListener listener = new SocketListener(socket);
                Thread thread = new Thread(listener);
                thread.start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    private static String findFirstProjectName() {
        File projectSettingsDir = new File("./prorefactor/projects");
        if (!projectSettingsDir.exists()) {
            return null;
        }
        FileFilter filter = new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory();
            }
        };
        File[] dirs = projectSettingsDir.listFiles(filter);
        if (dirs.length == 0) {
            return null;
        }
        return dirs[0].getName();
    }

    private static void loadProperties() throws IOException {
        String projectString;
        File propsfile = new File("proparseserver.properties");
        if (!propsfile.exists()) {
            projectName = Server.findFirstProjectName();
            return;
        }
        Properties props = new Properties();
        props.load(new FileInputStream(propsfile));
        String portString = props.getProperty("port");
        if (portString != null) {
            port = Integer.parseInt(portString);
        }
        projectName = (projectString = props.getProperty("project")) != null && projectString.length() > 0 ? projectString : Server.findFirstProjectName();
    }
}

